/*  Two videos in a window, one stops, one loops
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video/
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.video.*; 

// Step 1. Declare 2 Movie objects.
Movie movie1;
Movie movie2;

void setup() {  
  size(320, 480);  

  // Step 2. Initialize Movie objects. The movie files should live in the data folder.
  movie1 = new Movie(this, "countdown.mov"); 
  movie2 = new Movie(this, "crashtest.mov");

  // Step 3. Start playing movie.
  movie1.loop();
  movie2.play();
  // other parameters
  //movie1.speed(5);
  //movie2.volume(0);
}

// Step 5. Display movies.
void draw() {
  image(movie1, 0, 0, width, height/2);
  image(movie2, 0, 240, width, height/2);
}

// Step 4. Read new frames from the movie.
void movieEvent(Movie m) {  
  m.read();
}

/*
 From the movieEvent Help file in Processing:
 
 This event function is run when a new movie frame is available. 
 Use the read() method to capture this frame. If there is more than one movie in the program, 
 movieEvent() is called each time any of the movies has a new frame available. Use an if to 
 determine which movie is triggering the event. See the above example for implementation details.
 
 This function is for people who want to process the image data separately from drawing 
 (and as quickly as possible.) You cannot draw to the screen inside the movieEvent() function. 
 If you want to draw immediately based on the new image, then use the Movie.available() method. 
*/